<?php get_header();?>
<div id="wrap" class="row">
<?php $map = get_post_meta($post->ID, 'realtor_googleMap', true) ; ?>
<div id="content" class="<?php echo isFullWidth() ? 'twelve' : 'eight'; ?> columns">
		<div class="post-container short">	
			<?php if(have_posts()):?>
			<?php while(have_posts()):the_post();?>			
				<div class="post-title">				
					<h1><a href="<?php the_permalink();?>"><?php the_title();?> </a></h1>
					<div class="post-meta">
						Added: <?php the_time('F jS, Y');?>	<a href="#respond">Contact Us</a> regarding this listing.					
					</div> 
				</div><!--post-title-->
				<div class="featured">			 
					<?php if (count(getPhotoAttachements($post->ID)) > 0):?>
					<script type="text/javascript"> 
					   jQuery(window).load(function() {
						   jQuery('.featured').orbit({
								animation: 'horizontal-push', // fade, horizontal-slide, vertical-slide, horizontal-push
								animationSpeed: 800, // how fast animtions are
								timer: true, // true or false to have the timer
								resetTimerOnClick: false, // true resets the timer instead of pausing slideshow progress
								advanceSpeed: 4000, // if timer is enabled, time between transitions
								pauseOnHover: true, // if you hover pauses the slider
								startClockOnMouseOut: false, // if clock should start on MouseOut
								startClockOnMouseOutAfter: 1000, // how long after MouseOut should the timer start again
								directionalNav: true // manual advancing directional navs			
						   });
						   
					   });
					</script>
					<?php foreach (getPhotoAttachements($post->ID) as $attachment ): //not using my get image - due to href going to lightbox
							$src = wp_get_attachment_image_src($attachment->ID, 'full');
							$img = '<a href="' . $src[0] . '" rel="grp">';
							$img .= '<img src="' . myDir() . '/scripts/resize.php?src=' . $src[0] . '&amp;w=1024&amp;h=600&amp;q=100" alt="" />';
							$img .= '</a>';
							echo $img;					 					
						endforeach;	?>
					<?php endif; //end if theres photo attachments ?>					
					
				</div> 	
				<div class="post-content">
				<?php if($map != ''):?>			 
				<dl class="tabs two-up">
				  <dd class="active"><a href="#details">Listing Details</a></dd>
				  <dd><a href="#map">Maps / Street View</a></dd>
				</dl>
				<?php endif; //end if map has content ?>
				<ul class="tabs-content">
				<li class="active" id="detailsTab">		 
					<div class="overview">			
						<h6>Overview</h6>
						<ul>
							<?php echo get_the_term_list( $post->ID, 'type', '<li>Type: ', ', ', '</li>' ); ?> 
							<?php echo get_the_term_list( $post->ID, 'rooms', '<li>Rooms: ', ', ', '</li>' ); ?> 
							<?php echo get_the_term_list( $post->ID, 'area', '<li>Area: ', ', ', '</li>' ); ?>
							<?php echo get_the_term_list( $post->ID, 'price', '<li>Price: ', ', ', '</li>' ); ?>
							<li><a href="#respond">Contact Us</a> regarding this listing</li>
						</ul>
					</div>  
					<?php the_content();?>
				</li>
				<?php if($map != ''):?>		
					<li id="mapTab">				
					<?php echo $map;?>
					</li> 
				<?php endif; ?>
				</ul>
				</div><!--post-contetn-->			
			<?php endwhile;?>			
			<?php endif;?> 
			<?php comments_template( '/contact-form.php' ); ?> 			 
		</div><!--post-container-->		 
</div><!--end content-->
<?php if(!isFullWidth()){get_sidebar();	}; ?>
<?php get_footer();?>