<?php
/*
Template Name: Listings Search Results
*/
?>
<?php get_header();?>
<div id="wrap" class="row">
<?php if(!is_paged()):
	include (TEMPLATEPATH . '/search-listings-form.php');
	endif;
?>
<?php  
$list = array();
$item = array();  
foreach($_POST as $key => $value){
	if($value != ''){
		$item['taxonomy'] = htmlspecialchars($key);
		$item['terms'] = htmlspecialchars($value);
		$item['field'] = 'slug';
		$list[] = $item;
	}		
}  
$cleanArray = array_merge(array('relation' => 'AND'), $list);
$args['post_type'] = 'listings';
$args['showposts'] = 12;
$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
$args['paged'] = $paged;  
$args['tax_query'] = $cleanArray; 
$the_query = new WP_Query( $args ); //data is sanitized inside wp_query class  
?>
<div id="content" class="twelve columns">
<?php echo ($the_query->found_posts > 0) ? '<h3 class="foundPosts">' . $the_query->found_posts. ' listings found</h3>' : '<h3 class="foundPosts">We found no results</h3>';?>
<div class="row">
	<?php $x = 1; ?>		  
	<?php while ( $the_query->have_posts() ) : $the_query->the_post();?>			 
	<?php // include(TEMPLATEPATH . '/listings-box.php');?>	 
	<div class="four columns listing <?php echo $x == $the_query->found_posts ? 'end' : ''; ?>">
		<div class="post-container short">
		<?php echo has_post_thumbnail() ? my_get_image() :  my_get_image_blank();?> 
		<h5><a href="<?php the_permalink();?>"><?php the_title();?> </a></h5>
		<p>added <?php the_time('F j, Y');?><a class="small button" href="<?php the_permalink();?>">&rarr;</a></p>			 
		</div>
	</div>		
	<?php $x++; ?>
	<?php endwhile; wp_reset_postdata();?>		 
</div>
<div class="row page-navigation">
	<div class="twelve columns">
		<div class="alignleft"><?php next_posts_link('&laquo; Older Entries', $the_query->max_num_pages) ?></div>
		<div class="alignright"><?php previous_posts_link('Newer Entries &raquo;') ?></div>
	</div>
</div>	 
</div><!--end content-->
<?php // get_sidebar();?>
<?php get_footer();?>