<?php
/*
Template Name: Home Page Template
*/
?>
<?php get_header();?>
<?php include(TEMPLATEPATH . '/options.php'); ?>
<div class="row homepage-bg">
	<div class="twelve columns centered">	
		<div class="seven columns">
		<?php if($realtor_welcomeMsg != ''){
			echo $realtor_welcomeMsg; } else { ?>		
			<!--default welcome message-->
			<h1><span>Welcome</span> to the Neighborhood</h1>	
			<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, 
			quis nostrud exercitation ullamco</p>
			<p>Laboris nisi ut aliquip ex ea <a href="#">commodo consequat</a></p>
			<!--end dfeault message-->
		<?php } ?>
		</div><!--end seven cols-->
		<div class="five columns nopadding">
		<?php include(TEMPLATEPATH . '/search-listings-form-sidebar.php'); ?>
		</div><!--end five cols-->	
	</div><!--end twelve cols-->
</div>
<div id="wrap" class="row">
<div id="content" class="twelve columns"> 
	<div class="row">		  
		<div class="four columns boxed">
			<h3>Latest Blog Posts</h3>
			<?php query_posts('posts_per_page=5');?>
			<ul>
				<?php if ( have_posts() ) : while ( have_posts() ) : the_post();?>
				<li><a href="<?php the_permalink();?>"><?php the_title();?></a></li>	
				<?php endwhile; else:?>
				<li>No Posts at the Moment...</li>
				<?php endif; ?>
			</ul>
			<?php wp_reset_query(); ?>	
		</div><!--end four-->
		<div class="four columns boxed">
		<h3>Blog Roll</h3>
			<ul>
			<?php wp_list_bookmarks('title_li=&categorize=0&limit=5');?>
			</ul>			 
		</div><!--end four-->
		<div class="four columns boxed about">
			<h3>About the Realtor</h3>	
			<?php include(TEMPLATEPATH . '/about-the-realtor.php'); ?>
		</div><!--end four-->
	</div><!--end row-->
	<div class="row">
	<h3 id="latest-listings"><span>Latest Listings</span></h3>
	<?php $the_query = new WP_Query('showposts=3&post_type=listings') ?>	
	<?php if($the_query->found_posts == 0){
		for($i=1; $i<=3; $i++){echo dummy_listings();}
	}else{ ?>	
		<?php while ( $the_query->have_posts() ) : $the_query->the_post();?>			 
			<div class="four columns listing">
				<div class="post-container short">
				<?php echo has_post_thumbnail() ? my_get_image(true) :  my_get_image_blank(true);?> 
				<h5><a href="<?php the_permalink();?>"><?php the_title();?> </a></h5>
				<p>added <?php the_time('F j, Y');?><a class="small button" href="<?php the_permalink();?>">&rarr;</a></p>			 
				</div>
			</div>			 
			<?php endwhile; wp_reset_postdata();?>			
	<?php } ?>
	</div><!--end row-->  
</div><!--end content-->
<?php // get_sidebar();?>
<?php get_footer();?>