<!DOCTYPE html>
<!-- paulirish.com/2008/conditional-stylesheets-vs-css-hacks-answer-neither/ -->
<!--[if lt IE 7]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="en"> <![endif]-->
<!--[if IE 7]>    <html class="no-js lt-ie9 lt-ie8" lang="en"> <![endif]-->
<!--[if IE 8]>    <html class="no-js lt-ie9" lang="en"> <![endif]-->
<!--[if gt IE 8]><!--> <html class="no-js" lang="en"> <!--<![endif]-->
<head>
	<meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>" />		
	<meta name="viewport" content="width=device-width" />
	<title><?php bloginfo('name'); ?><?php wp_title(); ?></title>

<!--
<script src="javascripts/modernizr.foundation.js"></script>
-->
<!-- IE Fix for HTML5 Tags -->
<!--[if lt IE 9]>
<script src="http://html5shiv.googlecode.com/svn/trunk/html5.js"></script>
<![endif]-->

<link rel="stylesheet" href="<?php echo  bloginfo('template_directory'); ?>/foundation-custom.css">	
<link href='http://fonts.googleapis.com/css?family=Lato:400,100,300,700,900,900italic,300italic' rel='stylesheet' type='text/css' />
<link rel="stylesheet" href="<?php bloginfo('stylesheet_url'); ?>" type="text/css" media="screen" />	
<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />
<?php wp_head(); ?>
<?php include(TEMPLATEPATH . '/options.php'); ?>
<!--for orbit to work-->
<script src="<?php bloginfo('template_directory');?>/scripts/foundation.js" type="text/javascript"></script>

<!-- Add mousewheel plugin (this is optional) -->
<script type="text/javascript" src="<?php bloginfo('template_directory');?>/scripts/jquery.mousewheel-3.0.6.pack.js"></script>

<!-- Add fancyBox -->
<link rel="stylesheet" href="<?php bloginfo('template_directory'); ?>/scripts/jquery.fancybox.css" type="text/css" media="screen" />
<script type="text/javascript" src="<?php bloginfo('template_directory');?>/scripts/jquery.fancybox.pack.js"></script>
<script type="text/javascript" src="<?php bloginfo('template_directory');?>/scripts/app.js"></script>
<script type="text/javascript" src="<?php bloginfo('template_directory');?>/scripts/tinynav.js"></script>
<link rel="shortcut icon" href="<?php echo ($realtor_favIconUrl != '') ? $realtor_favIconUrl : bloginfo('template_directory') . '/images/favicon.ico' ; ?>" />
<script type="text/javascript">
jQuery(document).ready(function() {
	jQuery(".orbit-slide, .gallery img").fancybox({
		mouseWheel : true, 
		fitToView : true,
		nextEffect : 'fade'
	});
	jQuery('ul.menu').tinyNav({
		active: 'selected'
	});
});
</script>
<style>
.homepage-bg {
<?php if($realtor_homeImg == ''){ ?>
	background:#324B73;
<?php } else { ?>
	background:url('<?php echo $realtor_homeImg; ?>') no-repeat;
	background-position:centre centre;
	-webkit-background-size:cover;
	-moz-background-size:cover;
	background-size:cover;
<?php } ?>
}
</style>
</head>
<body  <?php body_class(); ?>>
<header>
	<div class="row">
		<div id="access" class="twelve columns centered ">			
		<?php wp_nav_menu( array( 'container_class' => 'menu-header', 'theme_location' => 'header-menu' ) ); ?>
		</div><!-- #access -->
	</div>
	<div class="row">
		<div class="eight columns logo-layer">
			<a href="<?php bloginfo('url');?>"><?php echo ($realtor_logoUrl != '') ? '<img src="' . $realtor_logoUrl . '" alt="home" />' : bloginfo('name');?></a>
			<!--<span class="description hide-for-small"><?php bloginfo('description'); ?>	</span> -->
		</div>
		<div class="four columns search-layer hide-for-small">
		 <form role="search" method="get" id="searchform" action="<?php echo home_url( '/' ); ?>">
			<input type="text" value="" name="s" id="s" /> 
			<input type="submit" id="searchsubmit" value="Search" /> 	
		</form> 
			
		</div>	
	</div>
</header>