<?php
//menu
function register_my_menu() {
	register_nav_menu( 'header-menu', __( 'Header Menu' ) );	
}
//post thumbnail
if ( function_exists( 'add_theme_support' ) ) {
	add_theme_support( 'post-thumbnails' );	
}
if ( function_exists('register_sidebar') )
    register_sidebar(array(
        'before_widget' => '<div class="sidebar-box">',
        'after_widget' => '</div>',
        'before_title' => '<div class="title">',
        'after_title' => '</div>',
    ));
//insert jquery
function insert_jquery(){
	wp_enqueue_script('jquery');
}
function create_post_type_listings() {
	register_post_type( 'listings',
		array(
			'labels' => array(
				'name' => __( 'Listings' ),
				'singular_name' => __( 'Listing' )
			),
		'public' => true,
		'rewrite' => array('slug' => 'listing'),
		'has_archive' => true,		 
		'supports' => array('title', 'editor', 'excerpt', 'custom-fields', 'thumbnail', 'comments')
		)
	);
}
function listings_taxonomy() {  
   register_taxonomy(  
	'type',  
	'listings',  
	array(  
		'hierarchical' => true,  
		'label' => 'Type',  
		'query_var' => true,
		'rewrite' => array('slug' => 'type')  
		)  	
	); 
	register_taxonomy(  
	'rooms',  
	'listings',  
	array(  
		'hierarchical' => true,  
		'label' => 'Rooms',  
		'query_var' => true,
		'rewrite' => array('slug' => 'rooms')  
		)  	
	);  
	register_taxonomy(  
		'area',  
		'listings',  
		array(  
			'hierarchical' => true,  
			'label' => 'Area',  
			'query_var' => true,
			'rewrite' => array('slug' => 'area')  
		)  
	);
	register_taxonomy(  
		'price',  
		'listings',  
		array(  
			'hierarchical' => true,  
			'label' => 'Price',  
			'query_var' => true,
			'rewrite' => array('slug' => 'price')  
		)  
	);

}  
//register sidebar
function replace_excerpt($content) {	 
	return str_replace('[...]',
		   '<br /><a class="small button continue" href="'. get_permalink() .'">Continue Reading</a>',
		   $content
	);
}
// photo attachments in single listing
function getPhotoAttachements($id){
$args = array(
		'post_type' => 'attachment',
		'orderby' => 'menu_order',
		'order' => ASC,
		'numberposts' => -1,
		'post_status' => null,
		'post_parent' => $id
	);
	return get_posts($args);
}
function myDir(){
	return get_bloginfo('template_directory');
}
add_filter('the_excerpt', 'replace_excerpt');
add_filter( 'use_default_gallery_style', '__return_false' );
add_action('init', 'register_my_menu' );
add_action('init', 'insert_jquery');
add_action('init', 'create_post_type_listings' );
add_action('init', 'listings_taxonomy' );  
add_theme_support('post-thumbnails');
add_theme_support( 'menus' );
//meta boxes in single post pages
$prefix = 'realtor_'; 
$meta_box = array(
	'id' => 'my-meta-box',
	'title' => 'Listing Options',
	'page' => 'listings', //show in listings custom post type only
	'context' => 'normal',
	'priority' => 'high',
	'fields' => array(		
		array(
			'name' => 'Please select a style',
			'id' => $prefix . 'selectPageLayout',
			'type' => 'select',
			'options' => array('sidebar', 'full width')
		), 
		array(
			'name' => 'Google Map',
			'id' => $prefix . 'googleMap',
			'type' => 'textarea'
		)
	)
);
function mytheme_show_box() {
	global $meta_box, $post; 
	// Use nonce for verification
	echo '<input type="hidden" name="mytheme_meta_box_nonce" value="', wp_create_nonce(basename(__FILE__)), '" />';	 
	echo '<table class="form-table">';	 
	foreach ($meta_box['fields'] as $field) {
	// get current post meta data
	$meta = get_post_meta($post->ID, $field['id'], true);	 
	echo '<tr>',
	'<th style="width:20%"><label for="', $field['id'], '">', $field['name'], '</label></th>',
	'<td>';
	switch ($field['type']) {
		case 'text':
		echo '<input type="text" name="', $field['id'], '" id="', $field['id'], '" value="', $meta ? $meta : $field['std'], '" size="30" style="width:97%" />', '<br />', $field['desc'];
		break;
		case 'textarea':
		echo '<textarea name="', $field['id'], '" id="', $field['id'], '" cols="60" rows="4" style="width:97%">', $meta ? $meta : $field['std'], '</textarea>', '<br />', $field['desc'];
		break;
		case 'select':
		echo '<select name="', $field['id'], '" id="', $field['id'], '">';
		foreach ($field['options'] as $option) {
		echo '<option', $meta == $option ? ' selected="selected"' : '', '>', $option, '</option>';
		}
		echo '</select>';
		break;
		case 'radio':
		foreach ($field['options'] as $option) {
		echo '<input type="radio" name="', $field['id'], '" value="', $option['value'], '"', $meta == $option['value'] ? ' checked="checked"' : '', ' />', $option['name'];
		}
		break;
		case 'checkbox':
		echo '<input type="checkbox" name="', $field['id'], '" id="', $field['id'], '"', $meta ? ' checked="checked"' : '', ' />';
		break;
	}
	echo '<td>',
	'</tr>';
} 
echo '</table>';
}
function mytheme_save_data($post_id) {
	global $meta_box; 
	// verify nonce
	if (!wp_verify_nonce($_POST['mytheme_meta_box_nonce'], basename(__FILE__))) {
		return $post_id;
	} 
	// check autosave
	if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
		return $post_id;
	} 
	// check permissions
	if ('page' == $_POST['post_type']) {
	if (!current_user_can('edit_page', $post_id)) {
		return $post_id;
	}
	} elseif (!current_user_can('edit_post', $post_id)) {
		return $post_id;
	} 
	foreach ($meta_box['fields'] as $field) {
	$old = get_post_meta($post_id, $field['id'], true);
	$new = $_POST[$field['id']];	 
	if ($new && $new != $old) {
		update_post_meta($post_id, $field['id'], $new);
		} elseif ('' == $new && $old) {
			delete_post_meta($post_id, $field['id'], $old);
		}
	}
}
function mytheme_add_box() {
	global $meta_box; 
	add_meta_box($meta_box['id'], $meta_box['title'], 'mytheme_show_box', $meta_box['page'], $meta_box['context'], $meta_box['priority']);
}
add_action('admin_menu', 'mytheme_add_box');
add_action('save_post', 'mytheme_save_data');
function isFullWidth(){
	global $post;
	$x = get_post_meta($post->ID, 'realtor_selectPageLayout', true);
	if($x == 'full width'){
		return true;
	}elseif($x == 'sidebar'){
		return false;
	}else{
		return false;
	}
}
//custom tax for listing search form
function buildSelect($tax){	
	$terms = get_terms($tax);
	$x = '<select name="'. $tax .'">';
	$x .= '<option value="">Select '. ucfirst($tax) .'</option>';
	foreach ($terms as $term) {
	   $x .= '<option value="' . $term->slug . '">' . $term->name . '</option>';	
	}
	$x .= '</select>';
	return $x;
}
//get custom image, pass to resizer
function my_get_image($short=false){
	global $post;
	$h = ($short == false) ? '600' : '450';
	$src = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), array(9999, 9999));							
	$img = '<a href="' . get_permalink() . '">';
	$img .= '<img src="' . myDir() . '/scripts/resize.php?src=' . $src[0] . '&amp;w=960&amp;h=' . $h . '&amp;q=100" alt="" />';
	$img .= '</a>';
	return $img;
}
function my_get_image_blank($short=false){
	$i = ($short == false) ? 'blank.gif' : 'blank-short.gif';
	$img = '<a href="' . get_permalink() . '">';
	$img .= '<img src="' . myDir() . '/images/' . $i . '" />';
	$img .= '</a>';
	return $img; 
}
//show listings in the homepage
function dummy_listings(){
	$html  = '<div class="four columns listing">';
	$html .= '<div class="post-container short">';
	$html .= '<a href="#"><img src="' . myDir() . '/images/blank-short.gif" /></a>'; 
	$html .= '<h5><a href="#">100 Some Street</a></h5>';
	$html .= '<p>added August 12, 2012<a class="small button" href="#">&rarr;</a></p>';			 
	$html .= '</div></div>';
	return $html;
}
?>
<?php //theme options - no other code beyond this line
$themename = "Realty";
$shortname = "realtor";
$options = array (
array( "name" => "Header Settings",
	"type" => "sub-title"),
array(
	"type" => "open"
	),
array( 
	"name" => "Logo Url",
	"desc" => "Enter the full url of the image you want to use. Only use an image that is 40 pixels in height and 300 pixels in width",
	"id" => $shortname."_logoUrl",
	"type" => "text",
	"std" => ''
	),
array( 
	"name" => "Favicon Url",
	"desc" => "Enter the full url of the image you want to use for your Favicon. If blank, a default house icon is used.",
	"id" => $shortname."_favIconUrl",
	"type" => "text",
	"std" => ''
	),
array(
	"type" => "close"
	),
array( "name" => "Home Page Settings",
	"type" => "sub-title"),
array(
	"type" => "open"
	),
array( 
	"name" => "Home Page Background",
	"desc" => "Enter the full url of the image you want to use for the blue area in the homepage. Use a large image for better quality.",
	"id" => $shortname."_homeImg",
	"type" => "text",
	"std" => ''
	), 
array( 
	"name" => "Welcome Message",
	"desc" => "Enter the content you want in the welcome area in the home page. HTML is supported (Use H1 tags for the large text, and regular P tags for the paragraphs).",
	"id" => $shortname."_welcomeMsg",
	"type" => "textarea",
	"std" => ''
	),
array( 
	"name" => "About the Realtor Message",
	"desc" => "Enter the content you want in the About the Realtor area in the home page. HTML is supported. (Note that if you want your photo to appear - use a small jpeg - and it will be automatically pushed to the right, while content will be wrapped around it)",
	"id" => $shortname."_realtorMsg",
	"type" => "textarea",
	"std" => ''
	),
array(
	"type" => "close"
	),
array( "name" => "Footer Settings",
	"type" => "sub-title"),
array(
	"type" => "open"
	),
array( 
	"name" => "Footer Text",
	"desc" => "Enter the text you want to show in the footer area. This will be visible in all pages",
	"id" => $shortname."_footerText",
	"type" => "text",
	"std" => ''
	),
array(
	"type" => "close"
	)				
);

//presentation//

function mytheme_add_admin() {
 
global $themename, $shortname, $options;
 
if ( $_GET['page'] == basename(__FILE__) ) {
 
if ( 'save' == $_REQUEST['action'] ) {
 
foreach ($options as $value) {
update_option( $value['id'], $_REQUEST[ $value['id'] ] ); }
 
foreach ($options as $value) {
if( isset( $_REQUEST[ $value['id'] ] ) ) { update_option( $value['id'], $_REQUEST[ $value['id'] ]  ); } else { delete_option( $value['id'] ); } }
 
header("Location: themes.php?page=functions.php&saved=true");
die;
 
} else if( 'reset' == $_REQUEST['action'] ) {
 
foreach ($options as $value) {
delete_option( $value['id'] ); }
 
header("Location: themes.php?page=functions.php&reset=true");
die;
 
}
}
 
add_theme_page($themename." Options", "".$themename." Options", 'edit_themes', basename(__FILE__), 'mytheme_admin');
 
}
 
function mytheme_admin() {
 
global $themename, $shortname, $options;
 
if ( $_REQUEST['saved'] ) echo '<div id="message" class="updated fade"><p><strong>'.$themename.' settings saved.</strong></p></div>';
if ( $_REQUEST['reset'] ) echo '<div id="message" class="updated fade"><p><strong>'.$themename.' settings reset.</strong></p></div>';
 
?>
<div class="wrap">
<h2><?php echo $themename; ?> Settings</h2>
 
<form method="post">
 
<?php foreach ($options as $value) {
switch ( $value['type'] ) {
 
case "open":
?>
<table width="100%" border="0" style="background-color:#eef5fb; padding:10px;">
 
<?php break;
 
case "close":
?>
 
</table><br />
 
<?php break;
 
case "title":
?>
<table width="100%" border="0" style="background-color:#dceefc; padding:5px 10px;"><tr>
<td valign="top" colspan="2"><h3 style="font-family:Georgia,'Times New Roman',Times,serif;"><?php echo $value['name']; ?></h3></td>
</tr>

<!--custom-->
 
 
<?php break; 
case "sub-title":
?>
<h3 style="font-family:'Abel', Georgia,'Times New Roman',Times,serif; font-size:20px; padding-left:8px;"><?php echo $value['name']; ?></h3> 
<!--end-of-custom-->
 
 
<?php break;
 
case 'text':
?>
 
<tr>
<td valign="top" width="20%" rowspan="2" valign="middle"><strong><?php echo $value['name']; ?></strong></td>
<td width="80%"><input style="width:400px;" name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" type="<?php echo $value['type']; ?>" value="<?php if ( get_option( $value['id'] ) != "") { echo get_option( $value['id'] ); } else { echo $value['std']; } ?>" /></td>
</tr>
 
<tr>
<td><small><?php echo $value['desc']; ?></small></td>
</tr><tr><td colspan="2" style="margin-bottom:5px;border-bottom:1px dotted #000000;">&nbsp;</td></tr><tr><td colspan="2">&nbsp;</td></tr>
 
<?php
break;

case 'textarea':
?>
 
<tr>
<td valign="top" width="20%" rowspan="2" valign="middle"><strong><?php echo $value['name']; ?></strong></td>
<td width="80%"><textarea name="<?php echo $value['id']; ?>" style="width:400px; height:200px;" type="<?php echo $value['type']; ?>" cols="" rows="">
<?php if ( get_option( $value['id'] ) != "") 
{ 
echo stripslashes(get_option( $value['id'] )); 
} else { 
echo stripslashes($value['std']); 
} ?></textarea></td>
 
</tr>
 
<tr>
<td><small><?php echo $value['desc']; ?></small></td>
</tr><tr><td colspan="2" style="margin-bottom:5px;border-bottom:1px dotted #000000;">&nbsp;</td></tr><tr><td colspan="2">&nbsp;</td></tr>
 
<?php
break;
 
case 'select':
?>
<tr>
<td width="20%" rowspan="2" valign="middle"><strong><?php echo $value['name']; ?></strong></td>
<td width="80%"><select style="width:240px;" name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>"><?php foreach ($value['options'] as $option) { ?><option<?php if ( get_option( $value['id'] ) == $option) { echo ' selected="selected"'; } elseif ($option == $value['std']) { echo ' selected="selected"'; } ?>><?php echo $option; ?></option><?php } ?></select></td>
</tr>
 
<tr>
<td><small><?php echo $value['desc']; ?></small></td>
</tr><tr><td colspan="2" style="margin-bottom:5px;border-bottom:1px dotted #000000;">&nbsp;</td></tr><tr><td colspan="2">&nbsp;</td></tr>
 
<?php
break;
 
case "checkbox":
?>
<tr>
<td width="20%" rowspan="2" valign="middle"><strong><?php echo $value['name']; ?></strong></td>
<td width="80%"><?php if(get_option($value['id'])){$checked = "checked=\"checked\""; }else{ $checked = "";} ?>
<input type="checkbox" name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" value="true" <?php echo $checked; ?> />
</td>
</tr>
 
<tr>
<td><small><?php echo $value['desc']; ?></small></td>
</tr><tr><td colspan="2" style="margin-bottom:5px;border-bottom:1px dotted #000000;">&nbsp;</td></tr><tr><td colspan="2">&nbsp;</td></tr>
 
<?php break;
 
}
}
?>
 
<p class="submit">
<input name="save" type="submit" value="Save changes" />
<input type="hidden" name="action" value="save" />
</p>
</form>
<form method="post">
<p class="submit">
<input name="reset" type="submit" value="Reset" />
<input type="hidden" name="action" value="reset" />
</p>
</form>
 
<?php
}
add_action('admin_menu', 'mytheme_add_admin');

?>